/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.library.modifier.hooks;

import java.util.Collection;
import java.util.Iterator;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public interface OnHoldingPreventDeathHook {
    public float onHoldingPreventDeath(LivingEntity var1, IToolStackView var2, ModifierEntry var3, EquipmentContext var4, EquipmentSlot var5, DamageSource var6);

    default public boolean canIgnorePassInvul() {
        return false;
    }

    public static float onHoldingPreventDeath(ModuleHook<OnHoldingPreventDeathHook> hook, EquipmentContext context, DamageSource source, LivingEntity livingEntity) {
        for (EquipmentSlot slotType : EquipmentSlot.values()) {
            IToolStackView toolStack = context.getToolInSlot(slotType);
            if (toolStack == null || toolStack.isBroken()) continue;
            for (ModifierEntry entry : toolStack.getModifierList()) {
                float healthRemain = ((OnHoldingPreventDeathHook)entry.getHook(hook)).onHoldingPreventDeath(livingEntity, toolStack, entry, context, slotType, source);
                if (!(healthRemain > 0.0f)) continue;
                return healthRemain;
            }
        }
        return 0.0f;
    }

    public static boolean canIgnorePassInvul(ModuleHook<OnHoldingPreventDeathHook> hook, EquipmentContext context) {
        for (EquipmentSlot slotType : EquipmentSlot.values()) {
            Iterator iterator;
            IToolStackView toolStack = context.getToolInSlot(slotType);
            if (toolStack == null || toolStack.isBroken() || !(iterator = toolStack.getModifierList().iterator()).hasNext()) continue;
            ModifierEntry entry = (ModifierEntry)iterator.next();
            return ((OnHoldingPreventDeathHook)entry.getHook(hook)).canIgnorePassInvul();
        }
        return false;
    }

    public record FirstMerger(Collection<OnHoldingPreventDeathHook> modules) implements OnHoldingPreventDeathHook
    {
        @Override
        public float onHoldingPreventDeath(LivingEntity livingEntity, IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source) {
            for (OnHoldingPreventDeathHook module : this.modules) {
                float remainHealth = module.onHoldingPreventDeath(livingEntity, tool, modifier, context, slotType, source);
                if (!(remainHealth > 1.0f)) continue;
                return remainHealth;
            }
            return Float.MIN_VALUE;
        }

        @Override
        public boolean canIgnorePassInvul() {
            for (OnHoldingPreventDeathHook module : this.modules) {
                if (!module.canIgnorePassInvul()) continue;
                return true;
            }
            return false;
        }
    }
}

